;-----------------------------------------------------------
;idlharj2_tas_otos.pro
;-----------------------------------------------------------
ps=0
program='idlharj2_tas_otos'
psdirect,program,ps

;Tutkitaan tasaisesta jakaumasta otettujen satunnaislukujen keskiarvon
;suppenemista kohti teoreettista arvoa otoskoon kasvaessa.
;Tasaisen jakauman teoreettinen keskiarvo=mu, hajonta=sigma

;Valitaan eri otoskokoja N_tab=[N1, N2,...],
;lasketaan otoskeskiarvo xbar
;Erotuksen xbar-\mu  hajontaa kutsutaan keskiarvon keskivirheeksi

;Teoreettinen arvio = sigma/sqrt(N)
;Tutkitaan 'kokeellisesti': luodaan M kappaletta kutakin N luvun otosta 
;ja taltioidaan xbar-mu kullekin M, ja lopuksi nain taltioitujen
;erotusten otoshajonta taulokkoon otossigma_tab

;valitaan mielivaltaiset jakauman ala- ja ylaraja
   a=5. & b=10.
   mu=0.5*(a+b) &sigma=(b-a)/sqrt(12.)

;otoskoot
   N_tab=[100l,300l,1000l,3000l,10000l,30000l, 100000l]
;otoshajonnat tallennetaan taulukkoon
   otossigma_tab=n_tab*0.
;kutakin otosta luodaan M kappaletta
   M=20

   for in=0,n_elements(n_tab)-1 do begin
      N=n_tab(in)     
      xbar_tab=fltarr(m)   
      for im=0,m-1 do begin
         x=randomu(seed,n)*(b-a)+a
         xbar_tab(im)=mean(x)-mu
      endfor
      otossigma_tab(in)=stdev(xbar_tab)
   endfor
   
   nwin
   plot,n_tab,otossigma_tab,/ylog,/xlog,$
        title='satunnaisluvut tasaisesta jakaumasta',$
        xtitle='otoksen koko N',ytitle='otoskeskiarvon keskivirhe',psym=6
   oplot,n_tab,sigma/sqrt(n_tab),lines=2
   stm='(M='+strtrim(string(m),2)+')'
   label_data,0.25,0.9,[' keskivirhe:otos '+stm,' teoreettinen arvio'],$
              psym=[6,0],lines=[0,2]   
   psdirect,program,ps,/stop

;-----------------------------------------------------
;havainnollistetaan viela keskiarvon keskivirheen merkitysta
;verrataan xbar-mu jakaumaa 
;ja gaussista jakaumaa jonka hajonta  sigma/sqrt(N)

   program='idlharj2_tas_otos2'
   psdirect,program,ps

   M=10000                 ; monta otosta, jotta niista saataisiin hyva jakauma
   N=10                         ;otoskoolla ei valia (totea)

   xbar=fltarr(m)   
   for im=0,m-1 do begin
      x=randomu(seed,n)*(b-a)+a
      xbar(im)=mean(x)-mu
   endfor
   otossigma=stdev(xbar_tab)
   
   x1=-3*sigma/sqrt(n)
   x2= 3*sigma/sqrt(n)
   dx=(x2-x1)/100.
   histo_f,xbar,x1,x2,dx,xx,yy

   nwin
   yr=[0,max(yy)*1.5]
   plot,xx,yy,psym=10,xtitle='xbar-mu',ytitle='pdf',yr=yr,title='otoksien lukumaara M='+string(M)
   
;approksimoidaan gaussisella jakaumalla jonka 
;keskiarvo  mu_gauss=E(xbar-mu)=0
;hajonta    sigma_gauss=sigma/sqrt(N)
 
   sigma_gauss=sigma/sqrt(N)
   oplot,xx,1./sqrt(2.*!pi*sigma_gauss^2)*exp(-0.5*(xx/sigma_gauss)^2),lines=2

   stn='(N='+strtrim(string(n),2)+')'
   label_data,0.05,0.9,[' otoksen keskivirheen jakauma '+stn,' teoreettinen (suuri N)'],$
              psym=[0,0],lines=[0,2],size=.8

   psdirect,program,ps,/stop
end
