;-----------------------------------------------------------
;idlharj2_tas01
;-----------------------------------------------------------
;yksinkertainen plottaus
  program='idlharj2_tas'
  ps=-1
  psdirect,program,ps
  plot,randomu(seed,10000),psym=3
  psdirect,program,ps,/stop
;-----------------------------------------------------------------
  program='idlharj2_tas01'
  ps=-1
  psdirect,program,ps

;tasainen jakauma valilla 0-1
;valitaan eri N = satunnaislukujen lukumaara ja plotataan histogrammi. 
;histo_f laskee eri osavaleille osuvien arvojen lukumaarat
;ja normeeraa ne niin etta histogrammin pinta-ala = 1
;-> approksimoi tiheysfunktiota
;Jotta normeeraus oikein, jakauman on rajoituttava annettujen rajojen valiin
;histogram from x1 to x2 with step dx
;xx,yy return calculated values
;histo_f,x,x1,x2,dx,xx,yy,

  nwin
  !p.multi=[0,2,2]
  !y.range=[0,2]
  !y.style=1
  !p.charsize=0.7
;-------------------------------------------------------------------
  N=1000l
  dx=0.01
  x=randomu(seed,n)
  title='N=1000, dx=0.01 -> 10/bin'
  histo_f,x,-.2,1.2,dx,xx,yy
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',title=title,xs=1
;plotataan samaan kuvaan arvio yksittaisten pylvaiden vaihteluista:
; 
;   DELTA(NBIN)      sqrt(NBIN)           1
; --------------  = -------------  =  ----------
;      NBIN              NBIN         sqrt(NBIN) 
;
  xarg=[1,1]*1.1
  yarg=xarg*0.+1
  nbin=n*dx
  dyarg=xarg*0.+sqrt(1./nbin)
  oploterr,xarg,yarg,dyarg
  
;teoreeettinen tiheysjakauma
  xteo=findgen(101)/100.
  yteo=xteo*0.+1
  oplot,xteo,yteo,lines=0
;-------------------------------------------------------------------
  N=10000l
  dx=0.01
  x=randomu(seed,n)
  title='N=10000, dx=0.01 -> 100/bin'
  histo_f,x,-.2, 1.2,dx,xx,yy
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',title=title,xs=1
  
  nbin=n*dx
  dyarg=xarg*0.+sqrt(1./nbin)
  oploterr,xarg,yarg,dyarg
;-------------------------------------------------------------------
  N=100l
  dx=0.1
  x=randomu(seed,n)
  title='N=100, dx=0.1 -> 10/bin'
  histo_f,x,-.2, 1.2,dx,xx,yy
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',title=title,xs=1
  
  nbin=n*dx
  dyarg=xarg*0.+sqrt(1./nbin)
  oploterr,xarg,yarg,dyarg
;-------------------------------------------------------------------
  N=10000l
  dx=0.1
  x=randomu(seed,n)
  title='N=10000, dx=0.1 -> 1000/bin'
  histo_f,x,-.2,1.2,dx,xx,yy
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',title=title,xs=1
  
  nbin=n*dx
  dyarg=xarg*0.+sqrt(1./nbin)
  oploterr,xarg,yarg,dyarg
    
  !p.multi=0
  psdirect,program,ps,/stop
end


