;-----------------------------------------------------------
;idlharj2_gauss
;-----------------------------------------------------------
;Gaussisesti jakautuneet satunnaisluvut
;keskiarvo mu, hajonta sigma
;-----------------------------------------------------------

;yksinkertainen plottaus
;normeerattu normaalijakauma: mu=0, sigma=1
   program='idlharj2_gauss'
   ps=0
   psdirect,program,ps
   plot,randomn(seed,10000),psym=3
   psdirect,program,ps,/stop

;-----------------------------------------------------------------
;valitaan eri N = satunnaislukujen lukumaara ja plotataan
;histogrammi.+ verrataan teoreettiseen jakaumaan
  program='idlharj2_gauss1'
  ps=0
  psdirect,program,ps
  nwin
  !p.charsize=0.7

  sigma=3.
  mu=1.
  N=10000l
  title='N='+string(N)  
  x=sigma*randomn(seed,n)+mu

;histogrammi valilla -5*sigma -> 5*sigma
  x1=mu-5*sigma
  x2=mu+5*sigma
  dx=(x2-x1)/100.
  histo_f,x,x1,x2,dx,xx,yy
  plot,xx,yy,psym=10,xtitle='x',ytitle='pdf',title=title,xs=1

;teoreeettinen tiheysjakauma

  xteo=x1+(x2-x1)*findgen(1001)/1000.
  yteo=1./sqrt(2.*!pi)/sigma*exp(-0.5*(xteo-mu)^2/sigma^2)
  oplot,xteo,yteo,lines=0
    
  psdirect,program,ps,/stop

;-----------------------------------------------------------------
;kumulatiivinen tiheysfunktio

  sigma=3.
  mu=1.
  N=10000l
  x=sigma*randomn(seed,n)+mu

  program='idlharj2_gauss2'
  ps=0
  psdirect,program,ps
  nwin
;  plotataan otoksen luvut suurrujarjestyksessa, vastaavaksi y:n
;  arvoksi laitetaan 0/n, 

  plot,x(sort(x)), (lindgen(n)+1)/float(n),xtitle='x',$
       ytitle ='kumulatiivinen tiheysfunktio: P(X_i < x)',col=2
  

;teoreettinen, kayttaen IDL gauss_pdf-funktiota
    xteo=findgen(101)/100.*10.-5.
    yteo=gauss_pdf(xteo)

    oplot,xteo*sigma+mu,yteo,col=3,psym=6

    label_data,0.1,0.9,['otokselle laskettu','teoreettinen'],col=[2,3],psym=[0,6],lines=[0,0]
  psdirect,program,ps,/stop
end


