cSSBOX2004
c170605

C***********************************************************************
C         ssbox.inc
C***********************************************************************
                                                                        
          IMPLICIT DOUBLE PRECISION (A-H,O-Z)                           
                                                                        
C ******* FOLLOWING PARAMETERS DETERMINE SIZE OF PROGRAM:               
                                                                        

C         NIX = MAX(POTENTIAL IMPACT-PAIRS DURING ONE LARGE-STEP)             
C         NJX = MAX(POTENTIAL IMPACT-PAIRS SAVED FOR NEXT LARGE-STEP)
C         NSTAR=MAX NUMBER OF PARTICLES                                 
C         NZCUM=NUMBER OF Z-INTERVALS IN FORCE CALCULATION              
C         NZCUM2=NZCUM/2                                                
                                                 
                       
c          PARAMETER (NJX=90000,NIX=900000) 
          PARAMETER (NJX=250000,NIX=1500000) 
          PARAMETER (NSTAR=400001,NZCUM=2,NZCUM2=NZCUM/2)
          parameter (nstar2=800001)
          parameter (novermax =  2)
                                                                        
C ******* VARIABLES RELATED TO PARTICLES
          
          DIMENSION R(NSTAR,3),RP(NSTAR,3),ROTA(NSTAR,3)                
          DIMENSION S(NSTAR),MYY(NSTAR),IS(NSTAR)                       
          DOUBLE PRECISION MYY                                          
          COMMON /COORD/R,RP,S,MYY,ROTA,IS

c ******* variables related to encounters                               
                                                                        
          dimension agrav(nstar,3),xmass(nstar)                         
          common /enco1/agrav,xmass                                     
          common /enco2/encz,enclim,enclim2,encsoft,encsoft2            
                                                                        
C ******* VARIABLES RELATED TO SIZE DISTRIBUTION                        
                                                                        
          DIMENSION DSIG(0:10),NUM(10)                                  
          COMMON /SIZEDIST/ DSIG,NUM,QQ,NSIG,MJAK,SIGA,SIGB             
          common /isopart1/ indlarge                                    
          common /isopart2/ roolarge                                    
                                                                        
C ******* VARIABLES RELATED TO IMPACT MODEL                             
                                                                        
          DOUBLE PRECISION LAMDA,BETA,V0,VCRITA                         
          INTEGER IMODEL                                                
          COMMON /IMPMOD1/ LAMDA,BETA,V0,VCRITA,IMODEL                  
                                                                        
C ******* VARIABLES RELATED TO COLLISION-LISTS                          
                                                                        
          DIMENSION INDIX(NIX,2),NNIX(NIX),MMIX(NIX)       
          DIMENSION EROIX(NIX)
          COMMON /LISTPAR1/ INDIX,INDJX,NNIX,MMIX                       
          COMMON /LISTPAR2/ EROIX

              
          COMMON /LISTPAR3/ RAJA1MIN,RAJA3MIN,SIGTAR,SIGTER             
          COMMON /LISTPAR5/ TSMIN,TSMAX,TEPS,RAJA1,RAJA3                
          COMMON /LISTPAR6/ TCOLL,TCURR                                 
          COMMON /LISTPAR7/ TTNEW,TTOLD,TTSYS                           
          COMMON /LISTPAR8/ IISYS,JJSYS                                 
          COMMON /LISTPAR9/ IT1,IT3,LKMXR                               
          COMMON /LISTPAR0/ XRAJA,TULXR                                 
          COMMON /LISTPA11/ RAJA1MAX,RAJA3MAX,NUM1MAX,NUM3MAX           
          common /listpa12/ icloselim,iclosenum                         
                                                                        
C ****** VARIABLES RELATED TO OUTPUT                                    
                                                                        
          INTEGER COLL,COLLIT,COLLMAX,COLLS,COLLL,IDT,IDTMAX            
          INTEGER COLLOLDL,COLLOLDS,COLCOLO,COLLOLDE                    
          DOUBLE PRECISION ORB,PERIOD,TIME,DT,ORBVALI,ORBMAX            
          COMMON /TULPAR1/ COLL,COLLIT,COLLMAX,COLLS,COLLL,IDT,IDTMAX   
          COMMON /TULPAR2/ ORB,PERIOD,TIME,DT,ORBD,orbvali,ORBE,ORBMAX 
          COMMON /TULPAR3/ COLLOLDL,COLLOLDS,COLCOLO,NSTEPC,NSTEPT      
          COMMON /TULPAR4/ ORBOLD,TIMEOLDS,TIMEOLDE,TIMEOLDL            
          COMMON /TULPAR5/ COLLOLDE                                     
                                                                        
C ******* VARIABLES RELATED TO IMPACT-NUMBERS                           
c          INTEGER CMIN,CMAX,CL,CS                                       
          COMMON /IMPNUM1/ JXMIN,JXMAX,JXL,JXS,JX                       
          COMMON /IMPNUM2/ IXMIN,IXMAX,IXL,IXS,IX                       
c          COMMON /IMPNUM3/ INDMIN,INDMAX,INDL,INDS                      
c          COMMON /IMPNUM4/ JNDMIN,JNDMAX,JNDL,JNDS                      
c          COMMON /IMPNUM5/ CMIN,CMAX,CL,CS                              
          COMMON /IMPERO1/ ERO1MIN,ERO1MAX,ERO1L,ERO1S                  
          COMMON /IMPERO3/ ERO3MIN,ERO3MAX,ERO3L,ERO3S                  
          COMMON /IMPDT  / DTMIN,DTMAX,DTL,DTS                          
                                                                        
                                                                        
C ******* VARIABLES RELATED TO IMPACT-TESTS                             
          INTEGER DD0,DD1,DD2,DD3,DDMAX,DDITER,DDSUM,DDLKM,DDHH,DDY     
          INTEGER DD22,DDX,DDYX,DDOWN,DSYS                              
          COMMON /IMPTEST1/ DD0,DD1,DD2,DD3,DDMAX,DDITER,DDSUM          
          COMMON /IMPTEST2/ DDLKM,DDHH,DDY,DD22,DDX,DDYX,DDOWN,DSYS     
                                                                        
C ******* VARIABLES RELATED TO IMPACT-MEANS                             
C                     
                                                                        
          DIMENSION RPN(0:10,0:10,3),RPRPN(0:10,0:10,3,3)    
          DIMENSION CN(0:10,0:10,3),CCN(0:10,0:10,3,3)
          DIMENSION ICOLL(0:10,0:10)                                        
          DIMENSION ALFT(0:10,0:10),ALFVT(0:10,0:10),
     +    ALFVTT(0:10,0:10)              
          DIMENSION VT(0:10,0:10),VTT(0:10,0:10)
          COMMON /IMPMEAN1/ RPN,RPRPN,CN,CCN                            
          COMMON /IMPMEAN2/ ALFT,ALFVT,ALFVTT,VT,VTT                    
          COMMON /IMPMEAN1/ ICOLL                                       
                                                                        
C ******* VARIABLES RELATED TO VELOCITY ELLIPSOIDS+VISCOSITY            
                                                                        
C         TXXC OUTPUT AFTER CERTAIN NUMBER OF IMPACTS                   
C         TXX  OUTPUT AFTER CERTAIN NUMBER OF ORBITS                    
C         TXXH OUTPUT TEMPORARY VALUES                                  
C         KTABLEC ETC K,Z,H                                             
C         QXXC COMPONENTS OF ROTATION-ELLIPSOID                         
C         QXC,QYC,QZC   MEAN ROTATION                                   
                                                                        
          DIMENSION TXX(0:10),TXY(0:10),TYY(0:10),TZZ(0:10)             
          DIMENSION VL(0:10),VNL(0:10)                                  
          DIMENSION TXXC(0:10),TXYC(0:10),TYYC(0:10),TZZC(0:10)         
          DIMENSION TXXH(0:10),TXYH(0:10),TYYH(0:10),TZZH(0:10)         
          DIMENSION QXXC(0:10),QXYC(0:10),QYYC(0:10),QZZC(0:10)         
          DIMENSION QXXH(0:10),QXYH(0:10),QYYH(0:10),QZZH(0:10)         
          DIMENSION QXH(0:10),QYC(0:10),QZC(0:10)                       
          DIMENSION QXC(0:10),QYH(0:10),QZH(0:10)                       
                                                                        
          double precision ktableH(0:10),ztableH(0:10),htableH(0:10)    
          double precision ktableC(0:10),ztableC(0:10),htableC(0:10)    
                                                                        
          DIMENSION VLC(0:10),VNLC(0:10)                                
          DIMENSION IBIN(0:10),IBOUT(0:10)                              
          COMMON /VELOE1/ TXX,TXY,TYY,TZZ,VL,VNL                        
          COMMON /VELOE2/ TXXC,TXYC,TYYC,TZZC,VLC,VNLC                  
          common /veloe3/ QXXC,QXYC,QYYC,QZZC,QXC,QYC,QZC               
          common /veloe4/ ktableC,ztableC,htableC                       
          COMMON /FLAGRO/ QZINIT                                        
          COMMON /IBOUND/ IBIN,IBOUT                                    

          common /add1/ txxh,txyh,tyyh,tzzh
          common /add2/ qxxh,qxyh,qyyh,qzzh
          common /add3/ qxh,qyh,qzh,ktableh,htableh,ztableh
                                                              
C ******* VARIABLES RELATED TO Z-DISTRIBUTION                           
                                                                        
          DIMENSION ZCUM(0:10,NZCUM),VCUM(0:10,NZCUM),FZT(0:NZCUM2)     
          INTEGER COLDZ2                                                
          COMMON /ZDIST1/ ZCUM,VCUM,FZT,FF0,DZCUM,ORBOLDZ2,ORBOLDZ1     
          COMMON /ZDIST2/ ISC,NZALI,NZYLI,COLDZ2                        
          COMMON /ZDIST3/ ORBSC,ORBZ1,ORBZ2                             
                                                                        
C ******* new VARIABLES RELATED TO Z-DISTRIBUTION                       
                                                                        
          DIMENSION VCUMU(0:10,NZCUM),DVCUMU(-NZCUM:NZCUM)              
          DIMENSION FFSIG(10),DIST2(-NZCUM:NZCUM)                       
          DIMENSION FZTS(0:10,0:NZCUM2),zsig(0:10)                      
          COMMON /ZDIST4/ VCUMU,DVCUMU,FFSIG,DIST2,fzts,zsig,dzsig      
          common /zdist5/ isgrav                                        
                                                                        
C ******* VARIABLES RELATED TO BOX+INITIAL VALUES                       
                                                                        
          DOUBLE PRECISION KAPPA,KAPPA2,KAPPAFAC                        
          COMMON /BOX1/ XL,YL,SIG4,LEV,LKM                              
          COMMON /BOX11/ XL1,XL2,XL0,YL0,KAPPAFAC,WZFAC,W0              
          COMMON /BOX2/ CEKS,CINK,TAU0,TAUMIN                           
          COMMON /BOX3/ ETA,OMEGA,KAPPA,WZ,OMEGA2,KAPPA2,WZ2,W2,ROO     
          COMMON /ENECONV/ ENES,ENEU,ETOT0,ECOLL,ESIIR,ESIIRV,ECOLLV    
          COMMON /BOXLIM1/ NHA,NHY,MSIS,NPA,NPY
          COMMON /SHEAR1/ AVAK,BVAK,VVAK,CVAK,FACTEMP,SHEAR             
          COMMON /TESTIT/ ITES,ISIS                                     
                                                                        
C ******* CPU-COUNTERS                                                  

          COMMON /CPUCPU1/ CPU_RET,CPU_LIM,CPU_POTA,CPU_POTB       
          COMMON /CPUCPU2/ CPU_TOT,CPU_INT
          COMMON /CPUCPU3/ CPU_RET0,CPU_LIM0,CPU_POTA0,CPU_POTB0           
          COMMON /CPUCPU4/ CPU_TOT0,CPU_INT0
          COMMON /CPUCPU5/ CPU_SG,CPU_SG0             
          COMMON /CPUCPU6/ CPU_SAV,CPU_SAV0          
                                                              
C ******* TEST-PARTICLES                                                
          DIMENSION IORBIT(500),ISORBIT(500)                             
          COMMON /TESTPAR1/ NNORBIT,NORBIT,IORBIT,ISORBIT               
          COMMON /TESTPAR2/ ORBTEST                                     
                                                                        
C ******* WIRE                                                          
          COMMON /WIREPAR1/ ROOWMAX,RADW,OMEW,DWIRE                     
          COMMON /WIREPAR2/ TW1,TW2,TW3,TW4                             
          COMMON /WIREPAR3/ IWIRE                                       
          common /prespar1/ presfac,prestole,csistole                   
          common /prespar2/ ipressure                                   
          common /dillpar1/ alfeps,alfome,eroixmax,alfmean,alfmax       
          integer alfstep                                               
          common /dillpar2/ alfstep,novermean 
                                                                        
                                                                        
          COMMON /MISC1/ ALFSUM,TALKU,TIMEOLD                           
          COMMON /MISC2/ NAPU4,NHIDAS05,NHIDAS,NHIDAS2,NHIDAS5,NHIDAS10 
          COMMON /MISC3/ ERO22R,ERO22M                                  
          COMMON /MISC4/ NPOT,NPOT0                                     
          COMMON /MISC5/ TIME0,tttest                                   
          COMMON /MISC6/ IITEST,JJTEST,incimp                           
          COMMON /MISC7/ rvisco,viscof                                  

          
          common /misc8/ijatko
                                   
          double precision igp
          common /misc10/igp,facgp

          common /feb98/nsav
c     i60 = number of fourier modes
c     idime=2 or 3
          common /feb98a/i60,idime

c     non-local pressure
          common /aug98a/pxnlc(0:10),pynlc(0:10),pznlc(0:10)

c       gridgravi
          
          dimension xgrid(512,256),ygrid(512,256)
          dimension fxgrid(512,256),fygrid(512,256)

          common /aug98b/encmin,tgrid,tmass
          common /aug98c/igrav,ngrav,nxg,nyg
          common /aug98d/cpugrav1,cpugrav2,cpugrav3,cpugrav4
          common /aug98e/xgrid,ygrid,fxgrid,fygrid
          common /aug98f/ gmet     
          common /aug98g/ nzg
          common /aug98h/ fzrange     

          dimension alftab(10,10),v0tab(10,10)
          common /alfvari1/ alftab,v0tab

c     Hertzian model

          common /mar99a/ epstab(2001),vtab(2001)
          common /mar99b/ ihertz,neps
          common /mar99c/ epsrho,epsa,epsd,epsb
          
          common /mar99d/ iisav(njx),jjsav(njx)
          common /mar99e/ tausav(njx),alfsav(njx),epssav(njx),
     +         timsav(njx),vcisav(njx)

          double precision lfric
          common /mar99f/ lfric,tseta0
       
          common /nov99a/ afidl
          common /oct00a/ mxgravi,mygravi
          common /jul01a/ erovak1,erovak2

c     these related to friction-checking
          common /sep01a/ ctul_frac
          common /sep01b/ vcisav_prev(njx),vtisav_prev(njx)
          common /sep01b/ vci_prev(nix),vti_prev(nix)

c     this has been missing?
          double precision lfricsav
          common /sep01c/ vtisav(njx),lfricsav(njx)


c     tracer-particles
c          double precision r_tracer(100000,3),rp_tracer(100000,3)
c          double precision agrav_tracer(100000,3)

c          common /nov01a/ r_tracer,rp_tracer,agrav_tracer
c          common /nov01b/ n_tracer


c     moonlet

c          common /mar02a/ n_moon
c          common /mar02b/ rad_moon,rho_moon
c          common /mar02c/ cen_moon

c     included spins
c          double precision rv_boundary(1000000,9)
c          common /mar02d/ rv_boundary     
c          common /mar02e/ n_boundary,i_boundary,l_boundary

c          common /mar02f/ veroix(NIX)
c          common /mar02g/ vero1MAX
c          common /mar02h/ eromax_zone(3)


c     the next two not used 
c     needed in rk_new
          common /mar02_new_a/index_pair(nstar),index_nopair(nstar),
     +         irank_pair(nstar)

c     needed in improved rk_new 
          integer badix
          dimension badix(nix)
          common /apr02a/ badix


c     tabulation for moonlet spin
          common /apr02b/ cv_sat,cc_sat(3,3),c_cross_v_sat(3)
          common /apr02c/ c_cross_vcoll_sat(3),q_sat(3)
          common /apr02d/ ncoll_sat,ncoll_cum_sat


          common /apr02e/ alfmax_FIRST,alfmean_FIRST,frek
          character(len=50) runid,codeid
          common /apr02f/ runid,codeid
          common /apr02g/ dmet,isearch_order
          common /apr02h/ cpustamp,orbstamp,orbori
          common /apr02i/ n_pair,n_nopair

          integer alfstep_nopair
          common /apr02j/ alfstep_nopair,novermean_first

          double precision myyspin
          common /apr02k/ rot_moon,myyspin

          common /apr02l/ cx_stamp,cy_stamp,cz_stamp,cxy_stamp
          common /apr02m/ vnl_stamp,pnl_stamp,vl_stamp
          common /apr02n/ qst_stamp,qcr2_stamp,qcr3_stamp,qz_stamp



c     gravitational viscosity

          common /may02a/ vgrav_near,vgrav_far,
     +         vtrans_local,vtrans_bulk
          common /may02b/ vgrav_near_stamp,vgrav_far_stamp,
     +         vtrans_local_stamp,vtrans_bulk_stamp
          common /may02c/ nstep_visco,nstep_visco_stamp
          common /may02d/ vg_lim1, vg_lim2
          common /may02dd/ vg_nx,vg_ny

c     first impacts

          common /may02e/ cv_sati,cc_sati(3,3),c_cross_v_sati(3)
          common /may02f/ c_cross_vcoll_sati(3),q_sati(3)
          common /may02g/ ncoll_sati,ncoll_cum_sati
          common /may02h/ ifresh_col(nstar)

          common /may02i/ rv_xyvelfac,rv_zvelfac,rv_zfac,rv_spinfac
          common /may02j/ rv_apuvx,rv_apuvy,rv_apuvz,
     +         rv_apurx2,rv_apury2,rv_apurz2,rv_apuzz,rv_apurz

          common /may02k/ zvak_all,zpvak_all,uvak_all,wvak_all,
     +         zmax_stamp

          integer simustep     
          common /may02l/ simustep     

          common /may02m/ fx_check2,fy_check2,fz_check3
          double precision myyspinfac1,myyspinfac2

          common /may02m/ cic,myyspinfac1,myyspinfac2             
          common /may02n/ ecoll2

          common /jul02a/ gamma_adh 
          common /dec02a/ fvisco1,fvisco2,
     +         fvisco1_stamp,fvisco2_stamp

          common /dec02b/ fdene1,fdene2,e_visco1,e_visco2,e_nl
          common /dec02c/ ecoll_nsc1,ecoll_nsc2,ecoll_nsc
          common /dec02d/ nha_coll,nhy_coll
          common /dec02e/ enes_coll,eneu_coll

c     shear-dependent wt-factor

          common /dec02f/ nzone_shear
          common /dec02g/ shear1,shear2,wt_shear1,wt_shear2
          common /dec02h/ shear_rzone(0:1001), shear_wz(0:1001),
     +         shear_xvy(1000),shear_x(1000),
     +         shear_xx(1000),shear_vy(1000),shear_n(1000),
     +         shear_rate(1000),shear_apu(0:1001)
    

          common /dec02i/ ecent_nsc,egrav_nsc,fdene0,fdene3

c     time when gravity was last evaluated
c     dA/dt for nearby gravity (ignoring any effects of impacts!)

          common /jan03a/ timesg, aagrav(nstar,3)

c     limit delta>ssum*glim in gravity (previously 1)
          common /jan03b/ glim     

c     moonlet gravity
          dimension agravm(nstar,3)

c     particle self-gravity
          dimension agravp(nstar,3)
          common /jan03c/ agravm,agravp
          common /jan03d/ t_debug1,t_debug2
          common /jan03e/ i_debug,j_debug


c     current seed of ran1
          common /jan03f/ iidum_save

c     different models to mimic  epst

          integer fricmodel
          common /jan03g/ fricmodel


c     make inclusion of infinite-sheet optional
c     make correction of Az optional

          common /feb03a/ gsheet,gcorr


c     individual eromax
c       update every dorb_eropart orbits
c       start using after coll_eropart collisions
c       safe_eropart = safety factor

         common /apr03a/eropart(nstar),collpart(nstar)
         common /apr03b/coll_eropart,dorb_eropart,safe_eropart
         common /apr03c/eropart_old(nstar),collpart_old(nstar)

c       egrav changes in borders

       common /apr03d/enes_grav,eneu_grav
       common /apr03e/enef_grav,eneb_grav

c       tabulation of viscosity
c       originating from different distances
       common /apr03f/VGRAV_near_tab(100)

c       tabulation of viscosities for size groups
c       including tangential force component fvisco11
c       these viscosities include mass

c       fdene3_sizeapu added 280603


       common /apr03g/ fvisco1_size(0:10),fvisco2_size(0:10),
     +       fvisco11_size(0:10),fvisco0_size(0:10),fvisco3_size(0:10),
     +  fvisco3_sizeapu(0:10),fdene3_sizeapu(0:10)        

       common /apr03h/ fdene0_size(0:10),fdene1_size(0:10),
     +       fdene11_size(0:10),fdene2_size(0:10),fdene3_size(0:10)

c       mtotsize = total mass (myy) in each size group
c       mtotsize(0) total mass of all

       double precision mtot_size(0:10)
       common /apr03i/ mtot_size

c       energies from boundary crossing
c                     over-border impact
c                     over-border gravity

       double precision e_obc_size(0:10),
     +  e_obi_size(0:10),e_obg_size(0:10)
       common /apr03j/ e_obc_size,e_obi_size,e_obg_size


c       spreading to unit 51  visco
       common /may03a/ nxcross_part(nstar)

c       transfer between size groups 060503

       common /may03b/ etrans1_size(0:10,0:10),etrans11_size(0:10,0:10),
     +       etrans2_size(0:10,0:10),etrans3_size(0:10,0:10)


c---------------------------------------------------
c       move here from gravi the declaration of fft-array size
c       --> easier to control the size of the executable

c	remember OS-runs would require larger nxmax!

c          parameter (nxmax=256,nymax=256,nzmax=16)
          parameter (nxmax=512,nymax=128,nzmax=16)
          parameter (nzmax2=2*nzmax,ndatamax=4*nxmax*nymax*nzmax)

c---------------------------------------------------
c       move here the 2dtab-arrays

c          real k2dvx(500,1000)
c          real k2dvy(500,1000)
c          real k2dn(500,1000)
c          real k2dvxx(500,1000)
c          real k2dvyy(500,1000)
c          real k2dvzz(500,1000)
c          real k2dvxy(500,1000)
c          real k2dzz(500,1000)
c          real k2dzv(500,1000)

c       common /may03c/ k2dvx,k2dvy,k2dn,k2dvxx,k2dvyy,k2dvzz,k2dvxy,
c     +         k2dzz,k2dzv              
c       common /may03d/ orb2d,n2dx,n2dy,dorb2d,forb2d,orb2d_start,
c     +    orb2d_num       


c-------------------------------------------
c       160603
c       shear corrected energy - size groups

       common /jun03a/ ekin_sc_size(0:10),ez_size(0:10),egrav_size(0:10)

c------------------------------------------
c       180603
c       calc_egrav =1 -> calculate egrav
c       calc_vg    =1 -> calculate vgn,vgf
c       nob_imp    =1 -> ignore boundary impacts
c                   2 -> ignore impacts over radial boundary 
c                   3 -> ignore impacts over tangential boundary
       
       integer calc_egrav, calc_vg

       common /jun03b/ calc_egrav, calc_vg, nob_imp

       common /jun03c/ erot_size(0:10)

c       calculation of etrans3 added 180603

       common /jun03d/ etrans3_sizeapu(0:10,0:10)
       common /jun03e/ time_visc_old


c----------------------------------------------
c       200603  divide fdene,fvisco size1-size2

       common /jun03f/ 
     +       fvisco1_sizeij(0:10,0:10),
     +       fvisco2_sizeij(0:10,0:10),
     +       fvisco11_sizeij(0:10,0:10),
     +       fvisco3_sizeij(0:10,0:10),
     +       fvisco3_sizeij_apu(0:10,0:10)        

       common /jun03g/ 
     +       fdene1_sizeij(0:10,0:10),
     +       fdene11_sizeij(0:10,0:10),
     +       fdene2_sizeij(0:10,0:10),
     +       flkm_sizeij(0:10,0:10)
       

c       complete pressure tensor
       common /jun03h/ 
     +       pvisco1_size(0:10,3,3),
     +       pvisco2_size(0:10,3,3),
     +       pvisco11_size(0:10,3,3),
     +       pvisco3_size(0:10,3,3),
     +       pvisco3_sizeapu(0:10,3,3)       


c ppvisco 191003

       common /oct03a/ nrad_pp, ndx_pp, nx_pp, ny_pp

c gravtest 011103

       common /nov03a/ type_gravtest,svak_gravtest

c _ff

       common /dec03a/ fh1,fh2,fh3


c 121203   tangential perturbation
c          range of modes perturbed
 
          common /dec03b/ afidly
          common /dec03c/ m_afidl1,m_afidl2




c 131203  form IIOCT
c     for heat conductivity/bulk viscosity

          double precision klaskuri
          double precision ktxx(500),ktyy(500),ktzz(500),ktxy(500)
          double precision khx(500),khnlx(500),kcoll(500),kzdisp(500)
          double precision khy(500),khnly(500)
          double precision ampzones(500),rampzones1(500),rampzones2(500)
          double precision kdens(500),ktx(500),kty(500),ktz(500)
          double precision kpnlx(500),kpnly(500),kpnlz(500),kloss(500)

          common /heat1/ namp
          common /heat2/ klaskuri,vamp,tamp,eamp,tkcollect
          common /heat3/ ktxx,ktyy,ktzz,ktxy,khx,khy,khnlx,khnly
          common /heat4/ kzdisp,kcoll,kdens,ktx,kty,ktz
          common /heat5/ ampzones,rampzones1,rampzones2 
          common /heat6/ kpnlx,kpnly,kpnlz,kloss

          double precision kvx(500),kvy(500),kvz(500)
          common /heat7/ kvx,kvy,kvz
          
c         to check energy (ecoll2=subtract shear)
c          common /heat8/ ecoll2

          double precision kvnl(500),kloss_sc(500),zloss_sc(-200:200)
          common /heat9/ kvnl,kloss_sc,zloss_sc
          
          common /heat10/ nwave
          common /vamp_delay/ start_amp,dstart_amp

c         collection intervals:store,output
          common /dec2003_heat/ dorbk1,dorbk2,drzone


c kvnl,kpnlx,kpnly,kpnlz are constructed from these:
c    1-imp-normal
c    11-imp-tangential
c    2-adhesion
c    3-gravity
c    L-local /non-corrected for systematic motion	
c    LL-local /corrected for systematic motion	

          common /dec2003_heat1/ pvisco1_rad(500,3,3),
     +            pvisco11_rad(500,3,3),
     +            pvisco2_rad(500,3,3),
     +            pvisco3_rad(500,3,3),
     +            pviscoL_rad(500,3,3),
     +            pviscoLL_rad(500,3,3)

c energy-loss, transferred energy:
          double precision kloss1_rad(500),kloss2_rad(500)
          double precision kloss11_rad(500),kloss3_rad(500)
          double precision khnlx1_rad(500),khnlx2_rad(500)
          double precision khnlx11_rad(500),khnlx3_rad(500)

          common /dec2003_heat2/ kloss1_rad,khnlx1_rad,
     +            kloss11_rad,khnlx11_rad,
     +            kloss2_rad,khnlx2_rad,
     +            kloss3_rad,khnlx3_rad

c number of impacts:
          double precision kcoll_rad(500),surf_rad(500)
          common /dec2003_heat3/ kcoll_rad,surf_rad

c    kxv,kvy,kvz corrections ignored

          common /dec2003_heat4/ dene_stamp, 
     +          pnlxx_stamp,pnlyy_stamp,
     +          pnlzz_stamp,pnlxy_stamp,
     +          plxx_stamp,plyy_stamp,
     +          plzz_stamp,plxy_stamp


c 161203  particle-based quantities

          common /dec2003_part1/ nlaskuri,neigh_part
          common /dec2003_part2/ dorbn1,dorbn2,raja_part,tncollect


 	  real c_part(nstar,3),shear_part(nstar,4),pl_part(nstar,4),
     +         pnl_part(nstar,4),pg_part(nstar,4),dens_part(nstar),
     +         dtrans_part(nstar),dene_part(nstar)


          common /dec2003_part3/ c_part,shear_part,pl_part,
     +         pnl_part,pg_part,dens_part,
     +         dtrans_part,dene_part

c	
	  common /dec2003_part4/ orb_debug_part,mui_debug_part
	

c     copied from AXI260803
c     axisymmetric gravity
c         m_axi = number of fourier modes
c         rho_axi = mean density

         double precision m_axi,m_axi2
         common /aug03a/ m_axi,rho_axi,aximet,m_axi2



 	  real c2_part(nstar,3),pl2_part(nstar,4)
          common /feb2003a/ c2_part,pl2_part


c------------------------------------------------
c         add_sizegravi

          common /nov2004/ is_addgrav


c------------------------------------------------
c         Eero overlapping particles
c
          integer eh_tab(nstar)
          common /apr2005/ eh_tab


c	eccentric moonlet 170605

           double precision ink_moon
	   
           common /jun2005a/ cx_moon,cy_moon,eks_moon,ink_moon,
     +     delta_moon, gamma_moon	

c	impact paramater range
           common /jun2005b/ b_range,b_min,b_max


c	friction in radial velocities (to mimic impacts)
	   common /jun2005c/ tk_friction


c       
	  real roofac(nstar)
	  common /may2005/ roofac


c         minimum for storing fast impacts
          common /jan2007/v_fastmin



c----------------------------------------------------
c         spatial partitioning from mc_sub


         parameter(mmx=400,mmy=400)
         parameter(mmxy=mmx*mmy)

         dimension indtab_mc(nstar),numtab_mc(mmxy),mintab_mc(mmxy)
         dimension cxtab_mc(mmxy),cytab_mc(mmxy),dtab2_mc(mmxy)

         common /com9/indtab_mc,numtab_mc,mintab_mc
         common /com10/cxtab_mc,cytab_mc,dtab2_mc
         common /com11/mx_mc,my_mc



c----------------------------------------------------
c reduction factors to axisymmetric gravity
c allows combination to pp-gravity 27.02.07

	 double precision m_redu(3000)
         common /feb07a/ m_redu



c-----------------------------------------------
c  SIMPLE:
c  gravi_out.f tarvitse:
         common /jul07a/ apu_zmean,apu_zdisp,apu_xmin,apu_zmax
         dimension agrav_sheet(nstar)
         common /jul07b/ agrav_sheet

         real rhogrid3(nxmax,nymax,nzmax)
         real fxgrid3(nxmax,nymax,nzmax)
         real fygrid3(nxmax,nymax,nzmax)
         real fzgrid3(nxmax,nymax,nzmax)
         real frrho3(nxmax,nymax,nzmax2)
         real firho3(nxmax,nymax,nzmax2)
         real distx3(nxmax,nymax,nzmax2)
         real disty3(nxmax,nymax,nzmax2)
         real distz3(nxmax,nymax,nzmax2)
         real frdist3(nxmax,nymax,nzmax2)
         real fidist3(nxmax,nymax,nzmax2)


         common /jul07c/ rhogrid3,fxgrid3,fygrid3,fzgrid3,
     +   frrho3,firho3,distx3,disty3,distz3,frdist3,fidist3




c+++++++++c+++++++++c+++++++++c+++++++++c+++++++++c+++++++++c+++++++++72

          PARAMETER (PII=3.14159265358979312D0)                         
          PARAMETER (GM=3.7942D16)                                      
          PARAMETER (GG=6.67D-11)                                       
          PARAMETER (IDEV5=5, IDEV6=6, IDEV7=7,IDEV8=8, IDEV9=9)        
          PARAMETER (IDEV10=10, IDEV11=11, IDEV12=12,IDEV13=13)         
          PARAMETER (IDEV20=20, IDEV21=21, IDEV22=22,IDEV23=23)         
          PARAMETER (IDEV24=24, IDEV25=25, IDEV26=26,IDEV27=27)         
                                                                        
C***********************************************************************













